/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.ClientCreateDTO;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.entities.Client;
import com.hpay.hpay_mobile_api.repositories.ClientRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientService {
    @Autowired
    private ClientRepository clientRepository;

    public List<Client> getAllClients() {
        return this.clientRepository.findAll();
    }

    public Optional<Client> getClientById(Long id) {
        return this.clientRepository.findById(id);
    }

    public Client createClient(ClientCreateDTO clientCreateDTO) {
        Client client = new Client();
        client.setClientCode(clientCreateDTO.getClientCode());
        client.setNumPiece(clientCreateDTO.getNumPiece());
        client.setDateInscrit(clientCreateDTO.getDateInscrit());
        client.setIdTypePiece(clientCreateDTO.getIdTypePiece());
        client.setIdAgence(clientCreateDTO.getIdAgence());
        client.setIdGestionnaire(clientCreateDTO.getIdGestionnaire());
        client.setIdCommercial(clientCreateDTO.getIdCommercial());
        client.setGainCommercial(clientCreateDTO.getGainCommercial());
        client.setValider(clientCreateDTO.getValider());
        client.setGainPaye(clientCreateDTO.getGainPaye());
        return (Client)this.clientRepository.save(client);
    }

    public Client updateClient(Long id, Client clientDetails) {
        Client client = (Client)this.clientRepository.findById(id).orElseThrow(() -> new RuntimeException("Client not found"));
        client.setClientCode(clientDetails.getClientCode());
        client.setNom(clientDetails.getNom());
        return (Client)this.clientRepository.save(client);
    }

    public void deleteClient(Long id) {
        this.clientRepository.deleteById(id);
    }

    public List<Long> getClientIdsByPhoneNumbers(List<Integer> phoneNumbers) {
        return this.clientRepository.findClientIdsByPhoneNumbers(phoneNumbers);
    }

    public Client getClientByEmail(String email) {
        return this.clientRepository.findByEmail(email).orElse(null);
    }

    public Object updateFCMToken(Long idClient, String token) {
        Client client = this.clientRepository.findById(idClient).orElse(null);
        if (client == null) {
            return new ErrorResponse("Client not found", 404);
        }
        client.setFcmToken(token);
        this.clientRepository.save(client);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", client);
        return new SuccessResponse("update succesfull", 200, map);
    }
}

