/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.security;

import com.hpay.hpay_mobile_api.security.JwtRequestFilter;
import com.hpay.hpay_mobile_api.security.JwtTokenUtil;
import com.hpay.hpay_mobile_api.services.AuthService;
import jakarta.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    private final AuthService authService;
    private final JwtRequestFilter jwtRequestFilter;
    private final JwtTokenUtil jwtTokenUtil = new JwtTokenUtil();

    public SecurityConfig(AuthService authService, JwtRequestFilter jwtRequestFilter) {
        this.authService = authService;
        this.jwtRequestFilter = jwtRequestFilter;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.csrf(customizer -> customizer.disable()).authorizeHttpRequests().requestMatchers(new String[]{"/api/auth/**", "/api/pays/**", "/api/notification/**", "/api/ville/**", "/api/client/**", "/api/parrainages/**", "/api/messages/**", "/api/images/**", "/api/kyc/**", "/api/compte/**", "/api/benef/**", "/api/virement/**", "/api/depot-retrait/**", "/api/sochitel/**", "/swagger-ui.html", "/swagger-ui/**", "/v3/api-docs/**", "/swagger-resources/**", "/webjars/**", "/actuator/**"})).permitAll().anyRequest()).authenticated().and()).addFilterBefore((Filter)new JwtRequestFilter(this.jwtTokenUtil, this.authService), UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

