/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.SochitelRequest;
import com.hpay.hpay_mobile_api.DTO.SochitelResponseDto;
import com.hpay.hpay_mobile_api.entities.Compte;
import com.hpay.hpay_mobile_api.entities.Sochitel;
import com.hpay.hpay_mobile_api.repositories.CompteRepository;
import com.hpay.hpay_mobile_api.repositories.SochitelRepository;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SochitelService {
    private final SochitelRepository sochitelRepository;
    @Autowired
    private CompteRepository compteRepository;

    @Transactional
    public Sochitel insert(SochitelRequest r) {
        Compte compteFrom = this.compteRepository.findById((Object)r.getIdcompte()).orElse(null);
        if (compteFrom == null || compteFrom.getCloture().equals("1") || compteFrom.getCompteSuspendu().equals("1")) {
            return null;
        }
        Sochitel entity = Sochitel.builder().idClients(r.getIdclients()).idCompte(r.getIdcompte()).montant(r.getMontant()).frais(r.getFrais()).total(r.getTotal()).montantDebite(r.getMontantDebite()).deviseDebite(r.getDeviseDebite()).gainClient(r.getGainClient()).gainParrain(r.getGainParrain()).gainFranchise(r.getGainFranchise()).gainHpay(r.getGainHpay()).operatorId(r.getOperatorId()).operatorName(r.getOperatorName()).operatorAmount(r.getOperatorAmount()).operatorReference(r.getOperatorReference()).operatorCurrency(r.getOperatorCurrency()).countryId(r.getCountryId()).countryName(r.getCountryName()).userAmount(r.getUserAmount()).userCurrency(r.getUserCurrency()).userReference(r.getUserReference()).productId(r.getProductId()).productType(r.getProductType()).productTypeName(r.getProductTypeName()).reference(r.getReference()).timestamp(r.getTimestamp()).voucherPinNumber(r.getVoucherPinNumber()).voucherPinSerial(r.getVoucherPinSerial()).voucherPinInstruction(r.getVoucherPinInstruction()).commande(r.getCommande()).balanceInitial(r.getBalanceInitial()).transactionAmount(r.getTransactionAmount()).transactionCommission(r.getTransactionCommission()).transactionCommissionPercentage(r.getTransactionCommissionPercentage()).balanceFinal(r.getBalanceFinal()).balanceCurrency(r.getBalanceCurrency()).dateEff(r.getDateEff()).statut(r.getStatut() == null ? "1" : r.getStatut()).beneficiaire(r.getBeneficiaire()).idAgence(r.getIdagence()).build();
        compteFrom.setSolde(compteFrom.getSolde().subtract(BigDecimal.valueOf(r.getTotal().floatValue())));
        this.compteRepository.save((Object)compteFrom);
        return (Sochitel)this.sochitelRepository.save((Object)entity);
    }

    public Page<SochitelResponseDto> getTransactions(Integer idClient, Integer idCompte, LocalDateTime dateStart, LocalDateTime dateEnd, int page, int size, String sortDirection) {
        Sort sort = Sort.by((String[])new String[]{"dateEff"});
        sort = "desc".equalsIgnoreCase(sortDirection) ? sort.descending() : sort.ascending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        return this.sochitelRepository.searchTransactions(idClient, idCompte, dateStart, dateEnd, (Pageable)pageable);
    }

    public SochitelService(SochitelRepository sochitelRepository) {
        this.sochitelRepository = sochitelRepository;
    }
}

