/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.controllers;

import com.hpay.hpay_mobile_api.DTO.ClientCreateDTO;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.entities.Client;
import com.hpay.hpay_mobile_api.services.ClientService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/client"})
public class ClientController {
    @Autowired
    private ClientService clientService;

    @PostMapping(value={"/save/token"})
    public ResponseEntity<Object> changePassword(@RequestBody Map<String, Object> request) {
        Object response = this.clientService.updateFCMToken(Long.valueOf(request.get("idClient").toString()), request.get("token").toString());
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping
    public List<Client> getAllClients() {
        return this.clientService.getAllClients();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Client> getClientById(@PathVariable Long id) {
        Optional client = this.clientService.getClientById(id);
        return client.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Client> createClient(@RequestBody ClientCreateDTO clientCreateDTO) {
        Client createdClient = this.clientService.createClient(clientCreateDTO);
        return new ResponseEntity((Object)createdClient, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Client> updateClient(@PathVariable Long id, @RequestBody Client clientDetails) {
        Client updatedClient = this.clientService.updateClient(id, clientDetails);
        return ResponseEntity.ok((Object)updatedClient);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteClient(@PathVariable Long id) {
        this.clientService.deleteClient(id);
        return ResponseEntity.noContent().build();
    }
}

