/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.controllers;

import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.DTO.VirementInterneDTO;
import com.hpay.hpay_mobile_api.services.VirementInterneService;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/virement"})
public class VirementInterneController {
    @Autowired
    private VirementInterneService virementInterneService;

    @PostMapping(value={"/enregistrer"})
    public ResponseEntity<Object> saveVirement(@RequestBody VirementInterneDTO virementInterneDTO) {
        Object response = this.virementInterneService.saveVirement(virementInterneDTO);
        if (response instanceof SuccessResponse) {
            return ResponseEntity.status((int)200).body(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)response;
            return ResponseEntity.status((int)errorResponse.getStatusCode()).body((Object)errorResponse);
        }
        return ResponseEntity.status((int)400).body((Object)new ErrorResponse("Unknown error", 400));
    }

    @GetMapping(value={"/historique"})
    public ResponseEntity<Page<VirementInterneDTO>> getHistoriqueVirements(@RequestParam(required=false) Long idClient, @RequestParam(required=false) Long idCompte, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate, @RequestParam(defaultValue="asc") String sortDirection, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size) {
        Page result = this.virementInterneService.getHistorique(idClient, idCompte, startDate, endDate, sortDirection, page, size);
        return ResponseEntity.ok((Object)result);
    }
}

