/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.DepotRetraitDTO;
import com.hpay.hpay_mobile_api.entities.DepotRetrait;
import com.hpay.hpay_mobile_api.repositories.DepotRetraitRepository;
import com.hpay.hpay_mobile_api.repositories.SochitelRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class DepotRetraitService {
    private final DepotRetraitRepository repository;
    private final SochitelRepository sochitelRepository;

    public DepotRetrait save(DepotRetrait depotRetrait) {
        return (DepotRetrait)this.repository.save((Object)depotRetrait);
    }

    public Optional<DepotRetrait> findById(Integer id) {
        return this.repository.findById((Object)id);
    }

    public List<DepotRetrait> findAll() {
        return this.repository.findAll();
    }

    public void deleteById(Integer id) {
        this.repository.deleteById((Object)id);
    }

    public List<DepotRetrait> findByClient(Integer idClient) {
        return this.repository.findByIdClients(idClient);
    }

    public List<DepotRetrait> findByCompte(Integer idCompte) {
        return this.repository.findByIdCompte(idCompte);
    }

    public List<DepotRetrait> findByNumTransaction(String numTransaction) {
        return this.repository.findByNumTransaction(numTransaction);
    }

    public Page<DepotRetraitDTO> searchDepotsService(Integer idClient, Integer idCompte, LocalDateTime dateStart, LocalDateTime dateEnd, int page, int size, String sortDirection) {
        Sort sort = Sort.by((String[])new String[]{"dateTransaction"});
        sort = "DESC".equalsIgnoreCase(sortDirection) ? sort.descending() : sort.ascending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        Page depots = this.repository.searchDepots(idClient, idCompte, dateStart, dateEnd, (Pageable)pageable);
        return depots.map(d -> DepotRetraitDTO.builder().id(d.getId()).montant(d.getMontant()).frais(d.getFrais()).total(d.getTotal()).dateTransaction(d.getDateTransaction()).typeAction(d.getTypeAction()).clientId(d.getClient().getId()).clientCode(d.getClient().getClientCode()).nom(d.getClient().getNom()).prenoms(d.getClient().getPrenoms()).telephone(d.getClient().getTelephone()).email(d.getClient().getEmail()).urlPhoto(d.getClient().getPhotoClient()).compteId(d.getCompte().getIdCompte()).numCompte(d.getCompte().getNumCompte()).devise(d.getCompte().getDevise()).build());
    }

    public Page<DepotRetraitDTO> searchRetraitsService(Integer idClient, Integer idCompte, LocalDateTime dateStart, LocalDateTime dateEnd, int page, int size, String sortDirection) {
        Sort sort = Sort.by((String[])new String[]{"dateTransaction"});
        sort = "DESC".equalsIgnoreCase(sortDirection) ? sort.descending() : sort.ascending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        Page depots = this.repository.searchRetraits(idClient, idCompte, dateStart, dateEnd, (Pageable)pageable);
        return depots.map(d -> DepotRetraitDTO.builder().id(d.getId()).montant(d.getMontant()).frais(d.getFrais()).total(d.getTotal()).dateTransaction(d.getDateTransaction()).typeAction(d.getTypeAction()).clientId(d.getClient().getId()).clientCode(d.getClient().getClientCode()).nom(d.getClient().getNom()).prenoms(d.getClient().getPrenoms()).telephone(d.getClient().getTelephone()).email(d.getClient().getEmail()).urlPhoto(d.getClient().getPhotoClient()).compteId(d.getCompte().getIdCompte()).numCompte(d.getCompte().getNumCompte()).devise(d.getCompte().getDevise()).build());
    }

    public DepotRetraitService(DepotRetraitRepository repository, SochitelRepository sochitelRepository) {
        this.repository = repository;
        this.sochitelRepository = sochitelRepository;
    }
}

