/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.entities.MessageSujet;
import com.hpay.hpay_mobile_api.repositories.MessageSujetRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class MessageSujetService {
    @Autowired
    private MessageSujetRepository messageSujetRepository;

    public Page<MessageSujet> getMessagesByClient(Integer clientId, Pageable pageable) {
        return this.messageSujetRepository.findByIdClients(clientId, pageable);
    }

    public Page<MessageSujet> getMessagesByClientAndLu(Integer clientId, String lu, Pageable pageable) {
        return this.messageSujetRepository.findByIdClientsAndLu(clientId, lu, pageable);
    }

    public MessageSujet markAsRead(Long id) {
        Optional optionalMessage = this.messageSujetRepository.findById((Object)id);
        if (optionalMessage.isPresent()) {
            MessageSujet message = (MessageSujet)optionalMessage.get();
            if (!"1".equals(message.getLu())) {
                message.setLu("1");
                message.setLuDate(LocalDateTime.now());
                return (MessageSujet)this.messageSujetRepository.save((Object)message);
            }
            return message;
        }
        throw new RuntimeException("Message non trouv\u00e9 avec l'id : " + id);
    }

    public long countNonLusByClient(Long clientId) {
        return this.messageSujetRepository.countByIdClientsAndLu(clientId, "0");
    }

    public int markAllAsReadByClient(Long clientId) {
        List unreadMessages = this.messageSujetRepository.findByIdClientsAndLu(clientId, "0");
        for (MessageSujet msg : unreadMessages) {
            msg.setLu("1");
            msg.setLuDate(LocalDateTime.now());
        }
        this.messageSujetRepository.saveAll((Iterable)unreadMessages);
        return unreadMessages.size();
    }
}

