/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.ParraineeDTO;
import com.hpay.hpay_mobile_api.entities.Client;
import com.hpay.hpay_mobile_api.entities.Parrainage;
import com.hpay.hpay_mobile_api.repositories.ParrainageRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParrainageService {
    @Autowired
    private ParrainageRepository parrainageRepository;

    public List<Parrainage> getAllParrainages() {
        return this.parrainageRepository.findAll();
    }

    public Parrainage saveParrainage(Parrainage parrainage) {
        return (Parrainage)this.parrainageRepository.save((Object)parrainage);
    }

    public Parrainage getParrainageById(Long id) {
        return this.parrainageRepository.findById((Object)id).orElse(null);
    }

    public void deleteParrainage(Long id) {
        this.parrainageRepository.deleteById((Object)id);
    }

    public List<Parrainage> getParrainagesByParrainId(Long idParrain) {
        return this.parrainageRepository.findByParrainId(idParrain);
    }

    public List<ParraineeDTO> getParraineesByParrainId(Long idParrain) {
        List parrainages = this.parrainageRepository.findByParrainId(idParrain);
        return parrainages.stream().map(parrainage -> {
            Client parrainee = parrainage.getParrainee();
            return new ParraineeDTO(parrainee.getId(), parrainee.getNom(), parrainee.getPrenoms(), parrainee.getTelephone(), parrainee.getPhotoClient());
        }).collect(Collectors.toList());
    }
}

