/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class S3Service {
    private final AmazonS3 amazonS3;
    @Value(value="${aws.s3.bucketName}")
    private String bucketName;

    public S3Service(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }

    public String uploadImage(MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        if (this.amazonS3.doesObjectExist(this.bucketName, fileName)) {
            throw new RuntimeException("Le fichier existe d\u00e9j\u00e0 dans le bucket S3.");
        }
        this.amazonS3.putObject(new PutObjectRequest(this.bucketName, fileName, file.getInputStream(), null));
        return "Fichier t\u00e9l\u00e9charg\u00e9 avec succ\u00e8s : " + fileName;
    }

    public String generateQRCodeAndUploadToS3(String text, String fileName) throws IOException, WriterException {
        int width = 300;
        int height = 300;
        BufferedImage qrImage = this.generateQRCodeImage(text);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)qrImage, "PNG", baos);
        byte[] imageBytes = baos.toByteArray();
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)imageBytes.length);
        metadata.setContentType("image/png");
        if (this.amazonS3.doesObjectExist(this.bucketName, fileName)) {
            throw new RuntimeException("Le fichier existe d\u00e9j\u00e0 dans le bucket S3.");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
        this.amazonS3.putObject(new PutObjectRequest(this.bucketName, fileName, (InputStream)inputStream, metadata));
        String url = this.amazonS3.getUrl(this.bucketName, fileName).toString();
        return url;
    }

    public BufferedImage generateQRCodeImage(String text) throws WriterException {
        HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, 200, 200, hints);
        BufferedImage image = new BufferedImage(200, 200, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 200, 200);
        graphics.setColor(Color.BLACK);
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 200; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                image.setRGB(i, j, Color.BLACK.getRGB());
            }
        }
        return image;
    }
}

