/*
 * Decompiled with CFR 0.152.
 */
package com.hpay.hpay_mobile_api.services;

import com.hpay.hpay_mobile_api.DTO.ClientDTO;
import com.hpay.hpay_mobile_api.DTO.CompteDTO;
import com.hpay.hpay_mobile_api.DTO.ErrorResponse;
import com.hpay.hpay_mobile_api.DTO.SuccessResponse;
import com.hpay.hpay_mobile_api.DTO.VirementInterneDTO;
import com.hpay.hpay_mobile_api.QuerySpecifications.VirementInterneSpecification;
import com.hpay.hpay_mobile_api.entities.Client;
import com.hpay.hpay_mobile_api.entities.Compte;
import com.hpay.hpay_mobile_api.entities.JournalTransfert;
import com.hpay.hpay_mobile_api.entities.LimiteTransfert;
import com.hpay.hpay_mobile_api.entities.MessageSujet;
import com.hpay.hpay_mobile_api.entities.VirementInterne;
import com.hpay.hpay_mobile_api.repositories.ClientRepository;
import com.hpay.hpay_mobile_api.repositories.CompteRepository;
import com.hpay.hpay_mobile_api.repositories.JournalTransfertRepository;
import com.hpay.hpay_mobile_api.repositories.MessageSujetRepository;
import com.hpay.hpay_mobile_api.repositories.VirementInterneRepository;
import com.hpay.hpay_mobile_api.services.ClientService;
import com.hpay.hpay_mobile_api.services.FCMService;
import com.hpay.hpay_mobile_api.services.LimiteTransfertService;
import com.hpay.hpay_mobile_api.services.LoginAdminService;
import com.hpay.hpay_mobile_api.utils.SMSapi;
import com.hpay.hpay_mobile_api.utils.SendEmail;
import jakarta.mail.MessagingException;
import jakarta.transaction.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class VirementInterneService {
    @Autowired
    private ClientService clientService;
    @Autowired
    FCMService fcmService;
    @Autowired
    private ClientRepository clientRepository;
    @Autowired
    private CompteRepository compteRepository;
    @Autowired
    private VirementInterneRepository virementInterneRepository;
    @Autowired
    private JournalTransfertRepository journalTransfertRepository;
    @Autowired
    private LimiteTransfertService limiteService;
    @Autowired
    private MessageSujetRepository messageSujetRepository;
    @Autowired
    LoginAdminService loginAdminService;

    public Date getStartOfToday() {
        LocalDate today = LocalDate.now();
        return Date.from(today.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public BigDecimal getTotalVirementsDuJour(Long idClientFrom) {
        Date startOfDay = this.getStartOfToday();
        System.out.println("Date from " + String.valueOf(startOfDay));
        return this.virementInterneRepository.getTotalVirementsOfDay(idClientFrom, startOfDay);
    }

    public long getNombreVirementsDuJour(Long idClientFrom) {
        Date startOfDay = this.getStartOfToday();
        return this.virementInterneRepository.countVirementsDuJour(idClientFrom, startOfDay);
    }

    @Transactional
    public Object saveVirement(VirementInterneDTO virementInterneDTO) {
        VirementInterne virementInterne = new VirementInterne();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyMMddHHmmssSSS");
        Client clientFrom = this.clientRepository.findById((Object)virementInterneDTO.getIdClientFrom()).orElse(null);
        if (clientFrom == null || !clientFrom.getValider().equals("1")) {
            return new ErrorResponse("client from not found", 401);
        }
        Client clientTo = this.clientRepository.findById((Object)virementInterneDTO.getIdClientTo()).orElse(null);
        if (clientTo == null || !clientTo.getValider().equals("1")) {
            return new ErrorResponse("client to not found", 401);
        }
        Compte compteFrom = this.compteRepository.findById((Object)virementInterneDTO.getIdCompteFrom()).orElse(null);
        if (compteFrom == null || compteFrom.getCloture().equals("1") || compteFrom.getCompteSuspendu().equals("1")) {
            return new ErrorResponse("compte from not found", 401);
        }
        Compte compteTo = this.compteRepository.findById((Object)virementInterneDTO.getIdCompteTo()).orElse(null);
        if (compteTo == null || compteTo.getCloture().equals("1") || compteTo.getCompteSuspendu().equals("1")) {
            return new ErrorResponse("compte to not found", 401);
        }
        if (compteFrom.getSolde().compareTo(virementInterneDTO.getTotal()) < 0) {
            return new ErrorResponse("insufficient balance", 401);
        }
        LimiteTransfert limitetransfertGlobal = this.limiteService.findById(Integer.valueOf(1)).orElse(null);
        if (limitetransfertGlobal == null) {
            return new ErrorResponse("Limite transfer not found", 401);
        }
        BigDecimal montantTotalInCAD = virementInterneDTO.getTotal().multiply(virementInterneDTO.getCadRate());
        System.out.println("montant en cad " + String.valueOf(montantTotalInCAD));
        System.out.println("montant limite en cad " + String.valueOf(limitetransfertGlobal.getMontantMaxParTransfert()));
        if (montantTotalInCAD.compareTo(limitetransfertGlobal.getMontantMaxParTransfert()) > 0) {
            return new ErrorResponse("montant limite par transfert d\u00e9pass\u00e9", 401);
        }
        BigDecimal totalVirementduJour = this.getTotalVirementsDuJour(virementInterneDTO.getIdClientFrom()).multiply(virementInterneDTO.getCadRate()).add(montantTotalInCAD);
        System.out.println("total virement journalier en cad " + String.valueOf(totalVirementduJour));
        System.out.println("limite journalier " + String.valueOf(limitetransfertGlobal.getMontantMaxJournalier()));
        if (totalVirementduJour.compareTo(limitetransfertGlobal.getMontantMaxJournalier()) > 0) {
            return new ErrorResponse("montant limite journalier depass\u00e9", 401);
        }
        long nbredevirementDuJour = this.getNombreVirementsDuJour(virementInterneDTO.getIdClientFrom());
        System.out.println("nombre de virement journalier " + nbredevirementDuJour);
        if (nbredevirementDuJour > (long)limitetransfertGlobal.getNbTransfertsMaxJournalier().intValue()) {
            return new ErrorResponse("nombre de transfert depass\u00e9", 401);
        }
        LocalDateTime now1 = LocalDateTime.now();
        virementInterne.setVirementInterneCode(now1.format(formatter));
        LocalDateTime now2 = LocalDateTime.now();
        virementInterne.setVirementNum(now2.format(formatter));
        virementInterne.setIdClientFrom(virementInterneDTO.getIdClientFrom());
        virementInterne.setIdClientTo(virementInterneDTO.getIdClientTo());
        virementInterne.setIdCompteFrom(virementInterneDTO.getIdCompteFrom());
        virementInterne.setIdCompteTo(virementInterneDTO.getIdCompteTo());
        virementInterne.setMontant(virementInterneDTO.getMontant());
        virementInterne.setFrais(virementInterneDTO.getFrais());
        virementInterne.setFraisMontant(virementInterneDTO.getFraisMontant());
        virementInterne.setTotal(virementInterneDTO.getTotal());
        virementInterne.setDateInitiale(new Date());
        virementInterne.setIdPaysFrom(virementInterneDTO.getIdPaysFrom());
        virementInterne.setVirementRaison(virementInterneDTO.getVirementRaison());
        virementInterne.setProgrammer(virementInterneDTO.getProgrammer());
        virementInterne.setDeviseFrom(virementInterneDTO.getDeviseFrom());
        virementInterne.setDeviseTo(virementInterneDTO.getDeviseTo());
        virementInterne.setTauxConversion(virementInterneDTO.getTauxConversion());
        virementInterne.setMontantTo(virementInterneDTO.getMontantCompteTo());
        virementInterne.setMontantFrom(virementInterneDTO.getMontantCompteFrom());
        virementInterne.setGainHpay(virementInterneDTO.getMontant().multiply(virementInterneDTO.getRealRate().subtract(virementInterneDTO.getHpayRate())));
        virementInterne.setGainHpayCAD(virementInterneDTO.getMontant().multiply(virementInterneDTO.getRealRate().subtract(virementInterneDTO.getHpayRate())).multiply(virementInterneDTO.getCadRate()));
        virementInterne.setTotalConverti(virementInterneDTO.getTotal());
        this.loginAdminService.ajouterSolde(virementInterneDTO.getMontant().multiply(virementInterneDTO.getRealRate().subtract(virementInterneDTO.getHpayRate())));
        virementInterne = (VirementInterne)this.virementInterneRepository.save((Object)virementInterne);
        compteFrom.setSolde(compteFrom.getSolde().subtract(virementInterneDTO.getMontantCompteFrom()));
        this.compteRepository.save((Object)compteFrom);
        compteTo.setSolde(compteTo.getSolde().add(virementInterneDTO.getMontantCompteTo()));
        this.compteRepository.save((Object)compteTo);
        JournalTransfert journalTransfert = new JournalTransfert();
        journalTransfert.setAction("valider_transfert");
        journalTransfert.setStatut("Ok");
        journalTransfert.setIdclient(clientFrom.getId());
        journalTransfert.setDate_action(LocalDateTime.now());
        journalTransfert.setUser_agent(null);
        journalTransfert.setIp_client(virementInterneDTO.getIp());
        journalTransfert.setUser_agent(virementInterneDTO.getAgent());
        this.journalTransfertRepository.save((Object)journalTransfert);
        if (clientTo.getFcmToken() != null) {
            System.out.println("envois de la notification");
            this.fcmService.sendNotification(clientTo.getFcmToken(), "Transfert d'argent re\u00e7u", "Vous avez re\u00e7u un montant de " + String.valueOf(virementInterneDTO.getMontant()) + " " + virementInterneDTO.getDeviseFrom() + " transfer\u00e9 par " + clientFrom.getPrenoms() + " " + clientFrom.getNom() + ".");
        }
        MessageSujet messageSujet = new MessageSujet();
        messageSujet.setIdSujet(Long.valueOf(2L));
        messageSujet.setIdClients(clientTo.getId());
        messageSujet.setSujet("Transfert d'argent re\u00e7u");
        messageSujet.setSujetMessage("Vous avez re\u00e7u un montant de " + String.valueOf(virementInterneDTO.getMontant()) + " " + virementInterneDTO.getDeviseFrom() + " transfer\u00e9 par " + clientFrom.getPrenoms() + " " + clientFrom.getNom() + ".");
        messageSujet.setSujetDate(LocalDateTime.now());
        this.messageSujetRepository.save((Object)messageSujet);
        LocalTime now = LocalTime.now();
        DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("HH:mm:ss");
        if (!clientFrom.getId().equals(clientTo.getId())) {
            try {
                SendEmail.sendEmailTransfertToClientFrom((String)clientFrom.getEmail(), (String)clientTo.getPrenoms(), (String)clientFrom.getPrenoms(), (String)virementInterneDTO.getMontantCompteFrom().toString(), (String)virementInterneDTO.getDeviseFrom(), (LocalDate)LocalDate.now(), (String)virementInterne.getVirementInterneCode(), (String)now.format(formatter1));
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        if (!clientFrom.getId().equals(clientTo.getId())) {
            try {
                SendEmail.sendEmailTransfertToClientTo((String)clientTo.getEmail(), (String)clientTo.getPrenoms(), (String)clientFrom.getPrenoms(), (String)virementInterneDTO.getMontantCompteFrom().toString(), (String)virementInterneDTO.getDeviseTo(), (LocalDate)LocalDate.now(), (String)virementInterne.getVirementInterneCode(), (String)now.format(formatter1));
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        SMSapi sms = new SMSapi();
        sms.alaSMS(clientFrom.getPays().getIndicatif() + clientFrom.getTelephone(), "Hpay: vous avez transfer\u00e9 " + virementInterneDTO.getMontantCompteFrom().toString() + " " + virementInterne.getDeviseFrom() + " \u00e0 " + clientTo.getPrenoms() + " le " + LocalDate.now().toString() + " \u00e0 " + now.format(formatter1) + ". Code:" + virementInterne.getVirementInterneCode());
        sms.alaSMS(clientFrom.getPays().getIndicatif() + clientTo.getTelephone(), "Hpay: vous avez re\u00e7u " + virementInterneDTO.getMontantCompteTo().toString() + " " + virementInterne.getDeviseTo() + " de " + clientFrom.getPrenoms() + " le " + LocalDate.now().toString() + " \u00e0 " + now.format(formatter1) + ". Code: " + virementInterne.getVirementInterneCode());
        HashMap<String, VirementInterne> map = new HashMap<String, VirementInterne>();
        map.put("data", virementInterne);
        return new SuccessResponse("le virement a \u00e9t\u00e9 effectuer", 200, map);
    }

    public Page<VirementInterneDTO> getHistorique(Long idClient, Long idCompte, LocalDateTime startDate, LocalDateTime endDate, String sortDirection, int page, int size) {
        Sort sort = Sort.by((String[])new String[]{"dateInitiale"});
        sort = "desc".equalsIgnoreCase(sortDirection) ? sort.descending() : sort.ascending();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        Specification spec = VirementInterneSpecification.withFilters((Long)idClient, (Long)idCompte, (LocalDateTime)startDate, (LocalDateTime)endDate);
        Page pageResult = this.virementInterneRepository.findAll(spec, (Pageable)pageable);
        return pageResult.map(arg_0 -> this.mapToDTO(arg_0));
    }

    private VirementInterneDTO mapToDTO(VirementInterne v) {
        VirementInterneDTO dto = new VirementInterneDTO();
        dto.setIdVirementInterne(v.getIdVirementInterne());
        dto.setMontant(v.getMontant());
        dto.setMontantTo(v.getMontantTo());
        dto.setMontantFrom(v.getMontantFrom());
        dto.setFraisMontant(v.getFraisMontant());
        dto.setTotal(v.getTotal());
        dto.setDateInitiale(v.getDateInitiale());
        dto.setVirementNum(v.getVirementNum());
        dto.setVirementRaison(v.getVirementRaison());
        dto.setDeviseFrom(v.getDeviseFrom());
        dto.setDeviseTo(v.getDeviseTo());
        dto.setTauxConversion(v.getTauxConversion());
        dto.setTotalConverti(v.getTotalConverti());
        dto.setGainHpay(v.getGainHpay());
        dto.setGainHpayCAD(v.getGainHpayCAD());
        dto.setProgrammer(v.getProgrammer());
        dto.setFrais(v.getFrais());
        this.clientRepository.findById((Object)v.getIdClientFrom()).ifPresent(client -> {
            ClientDTO c = new ClientDTO();
            c.setId(client.getId());
            c.setNom(client.getNom());
            c.setPrenoms(client.getPrenoms());
            c.setSexe(client.getSexe());
            c.setPhotoClient(client.getPhotoClient());
            dto.setClientFrom(c);
        });
        this.clientRepository.findById((Object)v.getIdClientTo()).ifPresent(client -> {
            ClientDTO c = new ClientDTO();
            c.setId(client.getId());
            c.setNom(client.getNom());
            c.setPrenoms(client.getPrenoms());
            c.setSexe(client.getSexe());
            c.setPhotoClient(client.getPhotoClient());
            dto.setClientTo(c);
        });
        this.compteRepository.findById((Object)v.getIdCompteTo()).ifPresent(compte -> {
            CompteDTO c = new CompteDTO();
            c.setIdCompte(compte.getIdCompte());
            c.setDevise(compte.getDevise());
            c.setNumCompte(compte.getNumCompte());
            dto.setCompteTo(c);
        });
        this.compteRepository.findById((Object)v.getIdCompteFrom()).ifPresent(compte -> {
            CompteDTO c = new CompteDTO();
            c.setIdCompte(compte.getIdCompte());
            c.setDevise(compte.getDevise());
            c.setNumCompte(compte.getNumCompte());
            dto.setCompteFrom(c);
        });
        return dto;
    }
}

